{smcl}
{* *! version 1.0.0 4aug2014}{...}
{title:Title}

{phang}
{bf:svarih llutkepohl {hline 2}} Heteroskedasticity-identified SVAR models, Lanne/Ltkepohl (2008) methodology


{marker syntax}{...}
{title:Syntax}

{p 12 27 2}
{cmd:svarih {ul:llu}tkepohl}
{depvarlist}
{ifin}
{cmd:,}
{opt rgmv:ar(rgmvarname)}
[{it:optional_options}]{p_end}

{synoptset 37 tabbed}{...}
{marker options}{...}
{synopthdr:options}
{synoptline}
{syntab:Model: IH part}
{synopt:{opt rgmv:ar(rgmvarname)}}identify regimes by contents of variable {it:rgmvarname}{p_end}
{synopt:{opt bcon:straints(constraints_b)}}apply previously defined {it:constraints_b} to {bf:B}{p_end}
{synopt:{opt be:q(matrix_beq)}}define and apply to {bf:B} equality constraint matrix {it:matrix_beq}{p_end}
{synopt:{opt bc:ns(matrix_bcns)}}define and apply to {bf:B} cross-parameter constraint matrix {it:matrix_bcns}{p_end}
{synopt:{opt lcon:straints(constraints_l)}}apply previously defined {it:constraints_e} to {bf:L}{p_end}
{synopt:{opt le:q(matrix_leq)}}define and apply to {bf:E} equality constraint matrix {it:matrix_leq}{p_end}
{synopt:{opt lc:ns(matrix_lcns)}}define and apply to {bf:E} cross-parameter constraint matrix {it:matrix_lcns}{p_end}

{syntab:Model: VAR part}
{synopt:{opth la:gs(numlist)}}use lags {it:numlist} in the underlying VAR{p_end}
{synopt:{opth ex:og(varlist:varlist_exog)}}use exogenous variables {it:varlist_exog}{p_end}
{synopt:{opt nocons:tant}}suppress constant term{p_end}
{synopt:{opt dfk}}make small-sample degrees-of-freedom adjustment{p_end}
{synopt:{opt sm:all}}report small-sample t and F statistics{p_end}

{syntab:Reporting and screen output}
{synopt:{opt l:evel(#)}}set confidence level{p_end}
{synopt:{opt var}}display underlying {opt var} output{p_end}
{synopt:{opt nocnsr:eport}}do not display constraints{p_end}
{synopt:{opt not:able}}do not display estimation results table{p_end}
{synopt:{it:{help svarih_llu##display_options:display_options}}}control column formats{p_end}

{syntab:Maximization}
{synopt:{opt evalm:ode(modenum)}}choose between d0, d1, and d2 evaluators; rarely used{p_end}
{synopt:{opt glsi:ter(glsiternum)}}perform a maximum number of {it:glsiternum} GLS iterations{p_end}
{synopt:{opt stol:erance(#)}}convergence criterion for GLS iteration on regime-specific residual covariance matrices{p_end}
{synopt:{opt btol:erance(#)}}convergence criterion for GLS iteration on ML coefficient vector{p_end}
{synopt:{opt glstr:ace}}display output of GLS iterations{p_end}
{synopt:{opt fixedfrom}}always use the same starting values for ML optimizations within the GLS iteration{p_end}
{synopt:{it:{help svarih_llu##maximize_options:maximize_options}}}control the maximization process{p_end}

{synopt :{opt coefl:egend}}display legend instead of statistics{p_end}
{synoptline}

{p 4 6 2}You must {cmd:tsset} your data before using {opt svarih llutkepohl}; see {helpb tsset:[TS] tsset}. {p_end}
{p 4 6 2}{it:varlist_exog} may contain time-series operators; see {help tsvarlist}.{p_end}
{p 4 6 2}{it:depvarlist} may NOT contain time-series operators.{p_end}
{p 4 6 2}See {help svarih_postestimation:svarih postestimation} for features available after estimation.{p_end}


{marker description}{...}
{title:Description}

{pstd}
{cmd:svarih llutkepohl} provides an alternative identification scheme for structural VARs than those implemented in {help svar}.
It implements a variant of the the "Identification through Heteroskedasticity" (IH) method as put forth in {help svarih_llu##LL2008:Lanne/Ltkepohl (2008)}.
For details of the model setup, see the {help svarih_llu##remarks:Remarks} section.
For general information on IH methods and for other IH methods that are available, see {help svarih}.

{pstd}
{cmd:svarih llutkepohl} is limited to two different states of volatility.


{marker abbreviations}{...}
{title:Abbreviations, definitions, notation}

{pstd}
This help entry uses abbreviations and definitions from {help svarih##abbreviations:svarih}.


{marker options}{...}
{title:Options}

{dlgtab:Model: IH part}

{phang}
{opt rgmv:ar(rgmvarname)} determines the variable whose observations identify the volatility regimes.
{cmd:svarih llutkepohl} is confined to two states of volatility and they must be numerically encoded in {it:rgmvarname} by integers 1 and 2.
Both values must occur in the estimation sample.

{pmore}
It is not a requirement that a particular regime be contiguous.

{phang}
{opt bcon:straints(constraints_b)}, {opt be:q(matrix_beq)}, {opt bc:ns(matrix_bcns)} have the same meaning and can be specified in a similar manner as {opt bconstraints}, {opt beq}, {opt bcns} in {cmd:svar}.
See the exposition {help svar:there}.
They define linear constraints on the contemporaneous shock impact matrix.
A difference to {cmd:svar} is that {opt bcon:straints()} does accept restrictions across model matrices B and L.

{pmore}
{opt be:q(matrix_beq)} defines equality constraints.
{it:matrix_beq} usually is an existing matrix but it may also be an expression as in {help matrix input} or a simple matrix function.
For example, {cmd:beq((.,0\.,.))} and {cmd:beq(I(2))} are allowed

{pmore}
{opt bc:ns(matrix_bcns)} defines cross-equation constraints.
Argument {it:matrix_bcns} can be supplied in the same way as {it:matrix_beq} from option {opt beq()}.

{pmore}
{opt bcon:straints(constraints_b)} can define either one.
They are defined using the {help constraint} command.

{phang}
{opt lcon:straints(constraints_l)}, {opt le:q(matrix_leq)}, {opt lc:ns(matrix_lcns)} work in the same way as {opt bconstraints}, {opt beq} and {opt bcns}.
They define linear constraints on the shock modification matrix L which is specific to the IH-LLU model.
In IH-LLU, L is a diagonal matrix.
{cmd:svarih llutkepohl} models the diagonal elements of L as a row vector.

{pmore}
Note that usage of option {opt lcns()} with positive integers goes against the global identification strategy of IH-LLU, since global identification requires that the elements of L be distinct.

{dlgtab:Model: VAR part}

{phang}
{opt la:gs(numlist)} see {help var} / {help svar}.

{phang}
{opth "exog(varlist:varlist_exog)"} see {help var} / {help svar}.

{phang}
{opt nocons:tant}; see
{bf:{help estimation options##noconstant:[R] estimation options}}.

{phang}
{opt dfk}  see {help var} / {help svar}.

{phang}
{opt sm:all} see {help var} / {help svar}.

{dlgtab:Reporting and screen output}

{phang}
{opt l:evel(#)}; see
{bf:{help estimation options##level():[R] estimation options}}.

{phang}
{opt var} specifies that the output from {opt var} also be displayed.
By default, the underlying VAR is fit {helpb quietly}.
This option is not available when you replay estimates.

{phang}
{opt nocnsr:eport}; see {helpb estimation options##nocnsreport:[R] estimation options}.

{phang}
{opt not:able} does not display the estimation output table.

{marker display_options}{...}
{phang}
{it:display_options}: {opth cformat(%fmt)}, {opt pformat(%fmt)}, and {opt sformat(%fmt)};
see {helpb estimation options##display_options:[R] estimation options}.

{dlgtab:Maximization}

{phang}
{opt evalm:ode(modenum)} will choose between d0, d1, and d2 evaluators.
Rarely used.
The default is 2.
Can be used to check the numerical robustness of large models.

{phang}
{opt glsi:ter(glsiternum)} determines the maximum number of GLS iterations.
Note that the default is 0, i.e. no GLS iterations at all.

{phang}
The following options are relevant only if {opt glsiter(glsiternum)}, {it:glsiternum}>0 is specified:

{phang2}
    {opt stol:erance(#)} and {opt btol:erance(#)} are two criteria that must both fulfilled for GLS convergence to be declared.

{phang3}{...}
        {opt stol:erance(#)} calculates a matrix relative difference of the regime-specific reduced-form covariance matrices of the current iteration to the ones from the previous iteration.
        This criterion is fulfilled if the matrix relative difference is less than {cmd:#}.
        The default for {cmd:#} is 1e-4.

{phang3}{...}
        {opt btol:erance(#)} calculates a matrix relative difference of the estimated ML coefficient vector of the current iteration to the one from the previous iteration.
        This criterion is fulfilled if the matrix relative difference is less than {cmd:#}.
        The default for {cmd:#} is 1e-4.

{phang2}
    {opt glstr:ace} outputs the following during each GLS iteration: the estimated coefficient vector, the regime-specific reduced-form covariance matrices, and the ML optimization of the current GLS iteration.

{phang2}
    {opt fixedfrom} specifies that the same starting values are used for the ML optimization in each GLS iteration.
    By default, the ML estimates from the previous iteration are used as starting values for the current ML optimization.

{marker maximize_options}{...}
{phang}
{it:maximize_options}:
{opt dif:ficult},
{opth tech:nique(maximize##algorithm_spec:algorithm_spec)},
{opt iter:ate(#)},
[{cmdab:no:}]{opt lo:g},
{opt tr:ace},
{opt grad:ient},
{opt showstep},
{opt hess:ian},
{opt showtol:erance},
{opt tol:erance(#)},
{opt ltol:erance(#)},
{opt nrtol:erance(#)},
{opt nonrtol:erance(#)}, and
{opt from(init_specs)};
see {manhelp maximize R}.

{phang}
{opt coeflegend}; see {helpb estimation options##coeflegend:[R] estimation options}.


{marker remarks}{...}
{title:Remarks}

{pstd}
Remarks are presented under the following headings:

    {help svarih_llu##modelequations:Model equations}
    {help svarih_llu##glsiteration:GLS iteration to achive ML estimates}
    {help svarih_llu##limitations:Limitations of the current implementation}

{marker modelequations}{...}
{title:Model equations}

{pstd}
{cmd:svarih llutkepohl} implements the IH-LLU method within a maximum likelihood framework as an extended SVAR B-model.
The extension consists of positing a priori knowledge about different regimes of volatility, i.e. time periods during which the structural shocks have different variances.
Consequently, a prerequisite for estimation is the specification of a variable that identifies these regimes, which in the following is referred to as the "regime variable".

{pstd}
In terms of a typical structural VAR equation that relates VAR residuals u_t to structural shocks e_t, the model equations of IH-LLU read

{p 40 40}
(1a)   u_t = B*e_t , t is in regime 1{break}
(1b)   u_t = B*L^(1/2)*e_t , t is in regime 2

{pstd}
As usual, B models the contemporaneous impact of shocks.
L is a diagonal matrix  and models the volatility differential between regimes 1 and 2.

{pstd}
If L is constrained to the identity matrix, (1a) and (1b) collapse into a standard SVAR B-model implemented in {help svar}.

{marker glsiteration}{...}
{title:GLS iteration to achieve ML estimates}

{pstd}
Estimation in {cmd:svarih llutkepohl} is based on the optimization of a likelihood function where the VAR-parameters have been concentrated out.
The VAR parameters are estimated by equation-by-equation OLS.
The resulting parameter estimates are consistent but neither efficient nor do they conincide with ML estimates, due to the assumed existence of different volatility regimes.
As a consequence, maximizing the concentrated likelihood will not result in ML estimates of the parameters of interest (the elements of B and L).
Lanne/Ltkepohl (2008) therefore propose an iterated feasible GLS procedure which converges to ML estimates.
In {cmd:svarih llutkepohl}, this GLS iteration is invoked through usage of option {opt glsiter}.
Note that its default value is zero, so if you do not use it, no GLS iterations are performed.
In this case, the concentrated likelihood is based on regular VAR lag coefficient estimates.
The reason for this implementation is that it is helpful to first check whether ML converges outside of GLS iterations.
If this is ensured, re-run the same specification with GLS iterations.

{pstd}
The sequence of calculations is as follows:

{p2colset 8 12 12 0}{...}
{p2col:1.}First, VAR parameter estimates of the lag coefficients are obtained using equation-by-equation OLS.
The regime-specific covariance matrices of the implied residuals for regimes 1 and 2 are calculated.{p_end}
{p2col:2.}The concentrated likelihood is maximized and estimates of B and L are obtained.{p_end}
{p2col:}If you omit option {opt glsiter} or if you explicitly specify {cmd:glsiter(0)}, the resulting estimates are returned.
If you specified {opt glsiter(glsiternum)}, {it:glsiternum}>0, the GLS iteration is started.{p_end}
{p2col:}{p_end}
{p2col:}{bf:GLS iteration}{p_end}
{p2col:3.}Based on the ML estimates of B and L, the regime-specific reduced-form covariance matrices are calculated as B*B' (regime 1) and B*L*B' (regime 2).{p_end}
{p2col:4.}Based on these two matrices, the implied ML VAR lag coefficients are re-estimated through a non-iterated feasible GLS estimator.{p_end}
{p2col:5.}Based on the GLS-VAR coefficients, the regime-specific covariance matrices of the implied residuals are calculated.{p_end}
{p2col:6.}The regime-specific residual covariance matrices are compared to the corresponding matrices of the previous iteration (to the ones of step 1 in the first iteration).
Starting in iteration 2, the current ML coefficient vector is also compared to the one from the previous iteration.
If all matrices pass a convergence criterion, GLS convergence is declared, and a final ML optimization for B and L is performed based on the GLS-VAR lag coefficient estimates.
If convergence was not achieved, the same ML optimization is performed, but subsequently the estimates B and L matrices are again used to start over at step 3.
{p_end}

{pstd}
This procedure has the following implications:

{p2colset 8 12 12 0}{...}
{p2col:-}With {cmd:glsiter(0)}, the estimates returned are based on regular VAR lag coefficients.
{cmd:e()} will contain the lag coefficient estimates in e(b_var) and their covariances in e(V_var).{p_end}
{p2col:-}With {opt glsiter(glsiternum)}, {it:glsiternum}>0, the estimates returned are based on the VAR-GLS estimates.
In addition to e(b_var) and e(V_var), {cmd:e()} will contain the relevant lag coefficient estimates in e(b_vargls) and their covariances in e(V_vargls).{p_end}
{p2col:-}Estimates are trustworthy if 1) {it:glsiternum}>0 has been used and 2) ML declared convergence and 3) GLS convergence has been declared.{p_end}

{marker limitations}{...}
{title:Limitations of the current implementation}

{p2colset 5 7 7 0}{...}
{p2col:The current implementation is subject to the following limitations:}{p_end}
{p2col:-}IH-LLU can equally be set up as an A-model instead of a B-model.
This has not been implemented.{p_end}
{p2col:-}While one main feature of IH-LLU is global identification of paramters (up to sign reversals of columns of model matrices), a local identification check would still be desirable.
A sufficient condition for the global identification is that the elements of L be distinct.
In some applications it may nevertheless be necessary to constrain some of the elements of L to be identical and in such situations a check for local identification would be of value.
This check is lacking from the current implementation.{p_end}
{p2col:-}While the check for global indentification also works for more than two regimes, {cmd:svarih llutkepohl} can currently only accomodate only two regimes.{p_end}
{p2col:-}{cmd:svarih llu} cannot re-estimate the monetary policy models of {help svarih_llu##LL2008:Lanne/Ltkepohl (2008)}, where IH-LLU was proposed.
This is because the models of the paper are set up in terms of parameters that underly the elements of B, and because there is no linear mapping between the two sets of parameters.{p_end}
{p2colreset}{...}


{marker examples}{...}
{title:Examples}

{pstd}
The following example illustrates the mechanics of IH-LLU.
It does not discuss the important issues of the interpretation of the shocks.
It focuses on the mechanics.
It builds on the example given in {cmd:svar} so you can compare the {cmd:svarih llu} setup to the one of {cmd:svar}.

{pstd}
Throughout this example section, we store estimated results in Stata's estimation results catalogue for later access.
The utility {help svarih examples} allows you to easily re-generate these estimates at any point.

{pstd}
We first load the data set and define constraints.
Then we estimate an {cmd:svar} model that is similar to the one of the examples section of {cmd:[TS] svar},
except that we choose to not restrict the estimation sample here, and that we model contemporaneous relationships strictly through the B-matrix.

{phang2}{stata webuse lutkepohl2:. webuse lutkepohl2}{p_end}
{phang2}{stata matrix aeq = I(3):. matrix aeq = I(3)}{p_end}
{phang2}{stata matrix beq = (.,0,0 \ .,.,0 \ .,.,.):. matrix beq = (.,0,0 \ .,.,0 \ .,.,.)}{p_end}
{phang2}{stata svar dln_inv dln_inc dln_consump, aeq(aeq) beq(beq):. svar dln_inv dln_inc dln_consump, aeq(aeq) beq(beq)}{p_end}
{phang2}{stata est store llu_svar:. est store llu_svar}{p_end}

{pstd}
In order to move to IH-LLU, we first must define a regime variable.
Furthermore, in order to illustrate the mechanics of IH-LLU, we make the following assumptions:
We have prior knowledge that the volatilities of the shocks in our model have changed in the 1970s.
We fix a period of differential volatilities of 1974q1.
The statement below creates a corresponding regime variable that contains values of 1 and 2, as required by {cmd:svarih llu}.

{phang2}{stata gen byte rgmvar = (qtr>=tq(1974q1)) + 1:. gen byte rgmvar = (qtr>=tq(1974q1)) + 1}{p_end}

{pstd}
It is worth reiterating that the occurence of regimes can be modeled to be much more complicated than this.
Any sequence and any multiplicity of regimes, with any occurence of gaps in the data, are allowed.
If there are enough observations, {cmd:svarih llu} will produce estimates.

{pstd}
IH-LLU has a diagonal multiplicative shock modification matrix L, which we decide to leave unconstrained.
We continue to work with a lower triangular B-matrix.

{phang2}{stata svarih llu dln_inv dln_inc dln_consump , rgmvar(rgmvar) beq(beq):. svarih llu dln_inv dln_inc dln_consump , rgmvar(rgmvar) beq(beq)}{p_end}
{phang2}{stata est store llu_first:. est store llu_first}{p_end}

{pstd}
The global identification check fails:
The minimum pairwise Wald statistic that tests for equality among L-elements provides no evidence that the elements of the L-matrix are distinct.
In such cases, a local identification check would come in handy, but this is currently not implemented in {cmd:svarih llu}.

{pstd}
Luckily, we have used constraints that make the present IH-LLU model equivalent to model bac_first, estimated in {help svarih_bac##examples:svarih bac}.
It can be shown that the estimates of the two models coincide.
Since {cmd:svarih bac} concluded with a successful local identification check, the same must hold true for the current IH-LLU model.

{pstd}
Still, in the following we will stop paying attention to identification issues, for the sake of illustrating the mechanics of the command. Some of the following specifications would not pass as valid in applied work.

{pstd}
An advantage of IH-LLU is that it has less stringent requirements concerning constraints than SVAR models. For example, it may be possible to leave B entirely unconstrained.
We estimate such a model, and test it against a model with a lower triangular B-matrix. To obtain proper ML estimates, both models are run with the {opt glsiter()} option.

{phang2}{stata svarih llu dln_inv dln_inc dln_consump , rgmvar(rgmvar) glsiter(100) notable nocnsreport:. svarih llu dln_inv dln_inc dln_consump , rgmvar(rgmvar) glsiter(100) notable nocnsreport}{p_end}
{phang2}{stata est store llu_unconstr_gls:. est store llu_unconstr_gls}{p_end}
{phang2}{stata svarih llu dln_inv dln_inc dln_consump , rgmvar(rgmvar) glsiter(100) notable nocnsreport beq(beq):. svarih llu dln_inv dln_inc dln_consump , rgmvar(rgmvar) glsiter(100) notable nocnsreport beq(beq)}{p_end}
{phang2}{stata est store llu_constr_gls:. est store llu_constr_gls}{p_end}
{phang2}{stata lrtest llu_constr_gls llu_unconstr_gls , stat:. lrtest llu_constr_gls llu_unconstr_gls , stat}{p_end}

{pstd}
The test rejects the constraints at the 5%-level.
Let's inspect the unconstrained estimates a little closer

{phang2}{stata estimates restore llu_unconstr_gls:. estimates restore llu_unconstr_gls}{p_end}
{phang2}{stata svarih , cmat l :. svarih , cmat l }{p_end}

{pstd}
Elements two and three of L are very close, and testing for their equality reproduces the minimum pairwise Wald-statistic in the global identification check:

{phang2}{stata test [l_1_2]_cons=[l_1_3]_cons:. test [l_1_2]_cons=[l_1_3]_cons}{p_end}

{pstd}
On the other hand, we can reject the hypotheses that all three elements are equal:

{phang2}{stata test [l_1_2]_cons=[l_1_3]_cons=[l_1_1]_cons:. test [l_1_2]_cons=[l_1_3]_cons=[l_1_1]_cons}{p_end}

{pstd}
We now impose in our next estimation that elements 2 and 3 of L be equal.

{phang2}{stata matrix lcns = (.,1,1):. matrix lcns = (.,1,1)}{p_end}

{pstd}
Note than the {opt lcns()} constraints option works differently than the {opt leq()} option.
The above statement says that two elements of L are constrained to be identical.
It does not say that they they are equal to one. This would have to be imposed through {opt leq()}.
We may have imposed the condition that the L-elements are equal by using any other positive integer:

{phang2}{stata matrix lcns = (.,5,5):. matrix lcns = (.,5,5)}{p_end}
{phang2}{stata svarih llu dln_inv dln_inc dln_consump , rgmvar(rgmvar) glsiter(100) lcns(lcns):. svarih llu dln_inv dln_inc dln_consump , rgmvar(rgmvar) glsiter(100) lcns(lcns)}{p_end}
{phang2}{stata est store llu_lcns:. est store llu_lcns}{p_end}

{pstd}
{cmd:predict} after {cmd:svarih llutkepohl} generates prediced values, residuals, shocks, and historical decompositions.
{cmd:dsimih} generates dynamic simulation statistics.
For all features available after estimation, see {help svarih postestimation}.

{pstd}
ADDENDUM: The following demonstrates the equivalence of specifications bac_first and llu_first.
We compare the (total) contemporaneous impact of shocks on the endogenous variables for each regime:

{phang2}{stata svarih examples llu_first , store:. svarih examples llu_first , store}{p_end}
{phang2}{stata svarih examples bac_first , store ereplace:. svarih examples bac_first , store ereplace}{p_end}
{phang2}{stata est table *_first , p:. est table *_first , p}{p_end}

{phang2}{stata matrix Ainv = inv(e(A)):. matrix Ainv = inv(e(A))}{p_end}
{phang2}{stata matrix bac_rgm1 = Ainv * e(B):. matrix bac_rgm1 = Ainv * e(B)}{p_end}
{phang2}{stata matrix bac_rgm2 = Ainv * (e(B)+e(E)):. matrix bac_rgm2 = Ainv * (e(B)+e(E))}{p_end}

{phang2}{stata qui est restore llu_first:. qui est restore llu_first}{p_end}
{phang2}{stata matrix llu_rgm1 = e(B):. matrix llu_rgm1 = e(B)}{p_end}
{phang2}{stata qui svarih , cmat bl nopval:. qui svarih , cmat bl nopval}{p_end}
{phang2}{stata matrix llu_rgm2 = r(BL):. matrix llu_rgm2 = r(BL)}{p_end}

{phang2}{stata matrix list bac_rgm1:. matrix list bac_rgm1}{p_end}
{phang2}{stata matrix list llu_rgm1:. matrix list llu_rgm1}{p_end}

{phang2}{stata matrix list bac_rgm2:. matrix list bac_rgm2}{p_end}
{phang2}{stata matrix list llu_rgm2:. matrix list llu_rgm2}{p_end}


{marker saved_results}{...}
{title:Saved results}

{pstd}
{cmd:svarih llutkepohl} saves the following in {cmd:e()}:

{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Scalars}{p_end}
{synopt:{cmd:e(N)}}number of observations{p_end}
{synopt:{cmd:e(N_cns)}}number of constraints{p_end}
{synopt:{cmd:e(k_eq)}}number of equations in {cmd:e(b)}{p_end}
{synopt:{cmd:e(k_dv)}}number of dependent variables{p_end}
{synopt:{cmd:e(k_aux)}}number of auxiliary parameters{p_end}
{synopt:{cmd:e(ll)}}log likelihood{p_end}
{synopt:{cmd:e(N_gaps)}}number of gaps in the sample{p_end}
{synopt:{cmd:e(k_var)}}number of coefficients in VAR{p_end}
{synopt:{cmd:e(k_eq_var)}}number of equations in underlying VAR{p_end}
{synopt:{cmd:e(k_dv_var)}}number of dependent variables in underlying VAR{p_end}
{synopt:{cmd:e(df_eq_var)}}average number of parameters in an equation{p_end}
{synopt:{cmd:e(df_r_var)}}if {cmd:small}, VAR residual degrees of freedom{p_end}
{synopt:{cmd:e(mlag)}}highest lag in VAR{p_end}
{synopt:{cmd:e(tmin)}}first time period in the sample{p_end}
{synopt:{cmd:e(tmax)}}maximum time{p_end}
{synopt:{cmd:e(rank)}}rank of {cmd:e(V)}{p_end}
{synopt:{cmd:e(ic_ml)}}number of iterations in the final ML optimization{p_end}
{synopt:{cmd:e(rc_ml)}}return code from {cmd:ml}{p_end}
{synopt:{cmd:e(converged_ml)}}{cmd:1} if {cmd:ml} declared convergence, {cmd:0} otherwise{p_end}
{synopt:{cmd:e(converged_gls)}}{cmd:1} if the GLS iteration declared convergence, {cmd:0} otherwise{p_end}
{synopt:{cmd:e(ic_gls)}}number of GLS iterations performed{p_end}
{synopt:{cmd:e(glsiter)}}maximium # of GLS iterations allowed in command execution{p_end}
{synopt:{cmd:e(numregimes)}}number of regimes marked by {it:regimevar}{p_end}
{synopt:{cmd:e(Wald_min)}}minimum value of the pairwise statistics of Wald tests for equality of elements of L{p_end}
{synopt:{cmd:e(Wald_p)}}p-value associated with e(Wald_min){p_end}

{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Macros}{p_end}
{synopt:{cmd:e(cmd)}}{cmd:svarih}{p_end}
{synopt:{cmd:e(method)}}{cmd:LLutkepohl}{p_end}
{synopt:{cmd:e(version)}}version number of command{p_end}
{synopt:{cmd:e(cmdline)}}command as typed{p_end}
{synopt:{cmd:e(lags)}}lags in model{p_end}
{synopt:{cmd:e(depvar)}}names of dependent variables{p_end}
{synopt:{cmd:e(rgmvar)}}name of variable that identifies regimes{p_end}
{synopt:{cmd:e(exog)}}names of exogenous variables, if specified{p_end}
{synopt:{cmd:e(nocons)}}noconstant, if {cmd:noconstant} specified{p_end}
{synopt:{cmd:e(cns_b)}}comprehensive list of constraints on B{p_end}
{synopt:{cmd:e(cns_l)}}comprehensive list of constraints on L{p_end}
{synopt:{cmd:e(dfk_var)}}alternate divisor ({cmd:dfk}), if specified{p_end}
{synopt:{cmd:e(small)}}{cmd:small}, if specified{p_end}
{synopt:{cmd:e(tsfmt)}}format of timevar{p_end}
{synopt:{cmd:e(timevar)}}name of timevar{p_end}
{synopt:{cmd:e(title)}}title in estimation output{p_end}
{synopt:{cmd:e(predict)}}program used to implement {cmd:predict}{p_end}
{synopt:{cmd:e(from)}}contents of maximization option {opt from}, if specified as a string{p_end}
{synopt:{cmd:e(mlopts)}}maximization options used{p_end}
{synopt:{cmd:e(regimes)}}regime encodings that occur in sample{p_end}
{synopt:{cmd:e(regimes_Ns)}}number of observations in each regime{p_end}
{synopt:{cmd:e(glsopts)}}GLS-related options supplied to command by user{p_end}

{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Matrices}{p_end}
{synopt:{cmd:e(b)}}coefficient vector{p_end}
{synopt:{cmd:e(Cns)}}constraints matrix{p_end}
{synopt:{cmd:e(Sigma)}}Residual covariance matrix of underlying VAR{p_end}
{synopt:{cmd:e(Sigma_rgm#)}}Residual covariance matrix for obs of regime #, based on the underlying GLS-VAR (if {opt glsiter(#)}, {it:#}>0) or of the underlying VAR{p_end}
{synopt:{cmd:e(V)}}variance-covariance matrix of the estimators{p_end}
{synopt:{cmd:e(b_var)}}coefficient vector of underlying VAR model{p_end}
{synopt:{cmd:e(V_var)}}VCE of underlying VAR model{p_end}
{synopt:{cmd:}}{p_end}
{synopt:{cmd:}}if GLS iteration was performed{p_end}
{synopt:{cmd:e(b_vargls)}}coefficient vector of underlying GLS-VAR model{p_end}
{synopt:{cmd:e(V_vargls)}}VCE of underlying GLS-VAR model{p_end}
{synopt:{cmd:}}{p_end}
{synopt:{cmd:e(beq)}}{cmd:beq(}{it:matrix}{cmd:)}, if specified{p_end}
{synopt:{cmd:e(bcns)}}{cmd:bcns(}{it:matrix}{cmd:)}, if specified{p_end}
{synopt:{cmd:e(leq)}}{cmd:leq(}{it:matrix}{cmd:)}, if specified{p_end}
{synopt:{cmd:e(lcns)}}{cmd:lcns(}{it:matrix}{cmd:)}, if specified{p_end}
{synopt:{cmd:e(B)}}estimated B matrix{p_end}
{synopt:{cmd:e(L)}}estimated diagonal of L matrix, returned as a row vector{p_end}
{synopt:{cmd:e(from)}}matrix of maximization option {opt from}, if specified as a matrix{p_end}
{synopt:{cmd:e(Wald)}}results of all pairwise Wald tests of equality of elements of L{p_end}

{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Functions}{p_end}
{synopt:{cmd:e(sample)}}marks estimation sample{p_end}
{p2colreset}{...}


{marker author}{...}
{title:Author}

{phang}
Daniel C. Schneider, Goethe University Frankfurt, dan_schneider@outlook.com


{marker acknowledgements}{...}
{title:Acknowledgements}

{pstd}
The code of official Stata's {cmd:svar} has served as a point of reference throughout the development of {cmd:svarih llutkepohl}.
Any remaining errors in {cmd:svarih llutkepohl} are mine.


{marker references}{...}
{title:References}

{marker LL2008}{...}
{phang}
Lanne, M. and H. Ltkepohl (2008): Identifying Monetary Policy Shocks via Changes in Volatility.
{it:Journal of Money, Credit and Banking}, 40 (6), 1131-1149.


{marker alsosee}{...}
{title:Also see}

{psee}
Help:
{helpb svar:[TS] svar},
{helpb svarih},
{helpb svarih bac},
{helpb svarih bfa},
{helpb svarih postestimation},
{helpb svarih cmat},
{helpb dsimih}
{p_end}

